local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// vals
	self.Value = 0;
	self.Minimum = 0;
	self.Maximum = 100;
	
	// smooth bar
	self.SmoothBar = false;
	self.Segmented = false;
	self.ShowPercent = false;
	self.CurrentWidth = 0;
	
end


// set range
function PANEL:SetRange( mins, maxs )
	self.Minimum = mins;
	self.Maximum = maxs;

end

// set smooth
function PANEL:SetAttrb( smooth, segment, percent )
	self.SmoothBar = smooth;
	self.Segmented = segment;
	self.ShowPercent = percent;
	self.CurrentWidth = 0;
	
end


// set value
function PANEL:SetValue( v )
	// call the value changed event.
	if( self.Value != v ) then
		if( self.LinkedClass ) then
			self.LinkedClass:CallEvent( "OnValueChanged", self.Value, v );
			
		end
		
	end
	
	// set value.
	self.Value = v;
	
end

// get value
function PANEL:GetValue( )
	return self.Value;

end


// draw
function PANEL:Paint( )
	// draw sizes.
	local color = AppFramework:CopyColor( AppFramework:Theme().colors['window_face'] );
	
	// width height
	local wwidth, height = self:GetSize();
	
	// calculate sizes.
	local width = math.floor( ( ( wwidth - 8 ) / ( self.Maximum - self.Minimum ) ) * ( self.Value - self.Minimum ) );
	
	// smoothbar?
	if( self.SmoothBar ) then
		// calculate color/width
		if( self.CurrentWidth != width ) then
			// calculate delta
			local delta = math.sin( CurTime() * 8 ) * 15;
			
			// adjust color, clamping to the valid range.
			color.r = math.Clamp( color.r + delta, 0, 255 );
			color.g = math.Clamp( color.g + delta, 0, 255 );
			color.b = math.Clamp( color.b + delta, 0, 255 );
	
			// width
			local rfrac = ( width - self.CurrentWidth ) * 0.1;
			if( rfrac > -1 && rfrac < 0 ) then rfrac = -1; end
			if( rfrac < 1 && rfrac > 0 ) then rfrac = 1; end
			self.CurrentWidth = math.floor( self.CurrentWidth + rfrac );
			
		end
		
		// set new width
		width = self.CurrentWidth;
		
	end
	
	
	// draw frame.
	AppFramework:Theme():DrawFrame( 0, 0, wwidth, height, FRAME_INSET );
	
	// draw bar.
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	
	// segmented?
	if( self.Segmented ) then
		local totalwidth = wwidth - 8;
		local totalsegments = math.ceil( totalwidth / 10 );
		local segments = math.ceil( ( totalsegments / totalwidth ) * width );
		
		// draw.
		local i, ofs = 0, 2;
		for i = 0, segments do
			// increment gap ofs.
			ofs = ofs + 2;
			
			// clamp width so it's in proper boundries.
			local segwidth = 8;
			if( ofs + segwidth > 4 + totalwidth ) then
				segwidth = totalwidth - ( ofs + segwidth );
				
			end
			
			// draw.
			surface.DrawRect(
				ofs, 4,
				segwidth, height - 8
			);
			
			// increment size.
			ofs = ofs + 8;
			
		end
		
	
	// flat
	else
		surface.DrawRect(
			4, 4,
			width - 2, height - 8
		);
		
	end
	
	
	// draw percentage?
	if( self.ShowPercent ) then
		// calculate percentage.
		local percent = math.floor( ( 100 / ( self.Maximum - self.Minimum ) ) * self.Value );
		
		// draw border.
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		
		// draw
		draw.SimpleText(
			percent .. "%",
			AppFramework:Theme().fonts['text'],
			wwidth * 0.5, height * 0.5,
			AppFramework:Theme().colors['text'],
			TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER
		);
	
	end
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_progressbar", PANEL, "Panel" );




// create app framework control.
CtlProgressBar_class 	= Control_class:create( nil, false, "ctl_progressbar" );

// set range
function CtlProgressBar_class:SetRange( mi, ma )
	self:GetHandle():SetRange( mi, ma );
	
end

// set value
function CtlProgressBar_class:SetValue( v )
	self:GetHandle():SetValue( v );
	
end

// get value
function CtlProgressBar_class:GetValue( )
	return self:GetHandle():GetValue();
	
end

// set smoothbar
function CtlProgressBar_class:SetAttrb( smooth, segment, percent )
	self:GetHandle():SetAttrb( smooth, segment, percent );
	
end
